<%@ page import="java.util.*, java.sql.*, java.util.ArrayList" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="ibase.utility.UserInfoBean, ibase.webitm.ejb.vhb.msq1.ApprovedRateOne" %>

<%
    System.out.println("@@@@@@@@ In ApprovedRateOne.jsp Khushal @@@@@@@@@@@@@@@@");
    UserInfoBean userInfo = (UserInfoBean) session.getAttribute("USER_INFO");

    if (userInfo == null) {
        out.print("<p style='color:red;'>Invalid session. Please log in.</p>");
        return;
    }
    
    String itemCode = request.getParameter("ITEM_CODE") != null ? request.getParameter("ITEM_CODE") : "";
    String quotNo1 = request.getParameter("QUOT_NO") != null ? request.getParameter("QUOT_NO") : "";
    
    System.out.println("@@@@@@@@ ITEM_CODE: " + itemCode);
    System.out.println("@@@@@@@@ QUOT_NO: " + quotNo1);
   
    if (itemCode.trim().isEmpty()) {
        out.print("<p style='color:red;'>Item code is missing.</p>");
        return;
    }
    
    if (quotNo1.trim().isEmpty()) {
        out.print("<p style='color:red;'>Quotation number is missing.</p>");
        return;
    }
  
    HashMap<String, ArrayList<String>> approvedMap = null;

    try {
        ApprovedRateOne approvedRateOne = new ApprovedRateOne(userInfo);
        approvedMap = approvedRateOne.getLastThreeQuotationRates(itemCode , quotNo1);
        System.out.println("approvedMap: " + approvedMap);
        
    } catch (Exception e) {
        e.printStackTrace();
        out.print("<p style='color:red;'>Error retrieving approved quotation details: " + e.getMessage() + "</p>");
        return;
    }
%>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Approved Quotation Details</title>
    <link type="text/css" rel="stylesheet" href="/ibase/webitm/css/sidePanelDisplay.css">
</head>
<body>

<h2>Approved Quotation Details</h2>

<form>
    <table border="1" class="itemtbl">
        <tr>
            <th>Customer Code</th>
            <th>Quotation No</th>
            <th>Quotation Date</th>
            <th>Item Code</th>
            <th>Approved Rate</th>
            <th>Quantity</th>
        </tr>
        <%
            if (approvedMap != null && !approvedMap.isEmpty()) {
                for (Map.Entry<String, ArrayList<String>> entry : approvedMap.entrySet()) {
                    ArrayList<String> values = entry.getValue();
        %>
        <tr>
            <% for (String value : values) { %>
                <td><%= value %></td>
            <% } %>
        </tr>
        <%
                }
            } else {
        %>
        <tr>
            <td colspan="5" style="color:red; text-align: center;">
                No approved quotations found for the selected item code & quotation no .
            </td>
        </tr>
        <% } %>
    </table>
</form>

</body>
</html>

